/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.util;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.js.AbstractJavaMethod;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.JavaSourceObject;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.jparser.JavaLexer;
import org.apache.ws.jaxme.js.jparser.JavaRecognizer;

public class JavaParser
implements Serializable,
Cloneable {
    private final JavaSourceFactory factory;
    private final List importStatements = new ArrayList();
    private final List generatedClasses = new ArrayList();
    private String packageName;

    public JavaParser(JavaSourceFactory pFactory) {
        this.factory = pFactory;
    }

    public JavaSourceFactory getFactory() {
        return this.factory;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String pPackageName) {
        this.packageName = pPackageName;
    }

    public List parse(File pFile) throws RecognitionException, TokenStreamException, FileNotFoundException {
        return this.parse(new FileReader(pFile));
    }

    public List parse(Reader pReader) throws RecognitionException, TokenStreamException {
        return this.parse(new JavaLexer(pReader));
    }

    private void showAST(int pLevel, AST pAST) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pLevel; ++i) {
            sb.append("  ");
        }
        System.out.println(sb.toString() + pAST.getType() + " " + pAST.getText());
        for (AST child = pAST.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.showAST(pLevel + 1, child);
        }
    }

    private void reset() {
        this.packageName = null;
        this.importStatements.clear();
    }

    public List parse(TokenStream pStream) throws RecognitionException, TokenStreamException {
        this.reset();
        JavaRecognizer parser = new JavaRecognizer(pStream);
        parser.compilationUnit();
        for (AST ast = parser.getAST(); ast != null; ast = ast.getNextSibling()) {
            this.parseAST(ast);
        }
        return this.generatedClasses;
    }

    private void parsePackageName(AST pAST) {
        this.setPackageName(this.parseIdentifier(pAST));
    }

    private void addImportStatement(JavaQName pQName) {
        this.importStatements.add(pQName);
    }

    private void parseImportStatement(AST pAST) {
        this.addImportStatement(JavaQNameImpl.getInstance(this.parseIdentifier(pAST)));
    }

    private String parseIdentifier(AST pAST) {
        StringBuffer sb = new StringBuffer();
        for (AST child = pAST.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.parseIdentifier(child, sb);
        }
        return sb.toString();
    }

    private String parseSimpleIdentifier(AST pAST) {
        StringBuffer sb = new StringBuffer();
        this.parseIdentifier(pAST, sb);
        return sb.toString();
    }

    private void parseIdentifier(AST pAST, StringBuffer sb) {
        switch (pAST.getType()) {
            case 50: {
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                sb.append(pAST.getText());
                break;
            }
            case 68: {
                sb.append(pAST.getText());
                break;
            }
            case 69: {
                boolean first = true;
                for (AST child = pAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append('.');
                    }
                    this.parseIdentifier(child, sb);
                }
                break;
            }
            case 17: {
                sb.append("[]");
                for (AST child = pAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.parseIdentifier(child, sb);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown token: " + pAST.getType());
            }
        }
    }

    private AST findChild(AST pAST, int pType) {
        for (AST child = pAST.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != pType) continue;
            return child;
        }
        return null;
    }

    private JavaSource getJavaSource(JavaSource pOuterClass, AST pAST) {
        AST classNameAST = this.findChild(pAST, 68);
        if (classNameAST == null) {
            throw new IllegalStateException("Missing class name");
        }
        String className = classNameAST.getText();
        if (pOuterClass == null) {
            String packageName = this.getPackageName();
            JavaQName qName = JavaQNameImpl.getInstance(packageName, className);
            JavaSource js = this.factory.newJavaSource(qName, JavaSource.DEFAULT_PROTECTION);
            this.generatedClasses.add(js);
            return js;
        }
        return pOuterClass.newJavaInnerClass(className, JavaSource.DEFAULT_PROTECTION);
    }

    private void parseModifiers(JavaSourceObject pObject, AST pAST) {
        AST modifiers = this.findChild(pAST, 5);
        if (modifiers == null) {
            throw new IllegalStateException("Missing MODIFIERS");
        }
        block8: for (AST child = modifiers.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 89: {
                    pObject.setProtection(JavaSource.PUBLIC);
                    continue block8;
                }
                case 90: {
                    pObject.setProtection(JavaSource.PROTECTED);
                    continue block8;
                }
                case 88: {
                    pObject.setProtection(JavaSource.PRIVATE);
                    continue block8;
                }
                case 65: {
                    pObject.setStatic(true);
                    continue block8;
                }
                case 40: {
                    pObject.setAbstract(true);
                    continue block8;
                }
                case 39: {
                    pObject.setFinal(true);
                }
            }
        }
    }

    private void parseModifiers(Parameter pParam, AST pAST) {
        AST modifiers = this.findChild(pAST, 5);
        if (modifiers == null) {
            throw new IllegalStateException("Missing MODIFIERS");
        }
    }

    private void parseModifiers(JavaSource pSource, AST pAST) {
        AST modifiers = this.findChild(pAST, 5);
        if (modifiers == null) {
            throw new IllegalStateException("Missing MODIFIERS");
        }
        block7: for (AST child = modifiers.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 89: {
                    pSource.setProtection(JavaSource.PUBLIC);
                    continue block7;
                }
                case 90: {
                    pSource.setProtection(JavaSource.PROTECTED);
                    continue block7;
                }
                case 88: {
                    pSource.setProtection(JavaSource.PRIVATE);
                    continue block7;
                }
                case 65: {
                    pSource.setStatic(true);
                    continue block7;
                }
                case 40: {
                    pSource.setAbstract(true);
                    continue block7;
                }
            }
        }
    }

    private JavaQName getQName(String pName) {
        String suffix;
        String firstIdent;
        if (pName.endsWith("[]")) {
            return JavaQNameImpl.getArray(this.getQName(pName.substring(0, pName.length() - 2)));
        }
        int offset = pName.indexOf(46);
        if (offset > 0) {
            firstIdent = pName.substring(0, offset);
            suffix = pName.substring(offset + 1);
        } else {
            firstIdent = pName;
            suffix = "";
        }
        for (int i = 0; i < this.importStatements.size(); ++i) {
            JavaQName qName = (JavaQName)this.importStatements.get(i);
            if (!qName.getClassName().equals(firstIdent)) continue;
            StringTokenizer st = new StringTokenizer(suffix, ".");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                qName = JavaQNameImpl.getInnerInstance(qName, s);
            }
            return qName;
        }
        return JavaQNameImpl.getInstance(pName);
    }

    private void parseImplementsOrExtends(JavaSource pSource, AST pAST, int pType) {
        AST implementsAST = this.findChild(pAST, pType);
        if (implementsAST == null) {
            throw new IllegalStateException("AST implements not found");
        }
        if (implementsAST.getFirstChild() != null) {
            String ident = this.parseIdentifier(implementsAST);
            JavaQName qName = this.getQName(ident);
            if (pType == 19) {
                pSource.addImplements(qName);
            } else {
                pSource.addExtends(qName);
            }
        }
    }

    private JavaField getJavaField(JavaSource pSource, AST pAST) {
        AST fieldNameAST = this.findChild(pAST, 68);
        if (fieldNameAST == null) {
            throw new IllegalStateException("Missing IDENT AST");
        }
        String fieldName = fieldNameAST.getText();
        AST type = this.findChild(pAST, 13);
        if (type == null) {
            throw new IllegalStateException("Missing TYPE AST");
        }
        String typeName = this.parseIdentifier(type);
        JavaQName typeQName = this.getQName(typeName);
        return pSource.newJavaField(fieldName, typeName, JavaSource.DEFAULT_PROTECTION);
    }

    private void parseFieldDefinition(JavaSource pSource, AST pAST) {
        JavaField jf = this.getJavaField(pSource, pAST);
        this.parseModifiers(jf, pAST);
    }

    private JavaMethod getJavaMethod(JavaSource pSource, AST pAST) {
        AST fieldNameAST = this.findChild(pAST, 68);
        if (fieldNameAST == null) {
            throw new IllegalStateException("Missing IDENT AST");
        }
        String fieldName = fieldNameAST.getText();
        AST type = this.findChild(pAST, 13);
        if (type == null) {
            throw new IllegalStateException("Missing TYPE AST");
        }
        String typeName = this.parseIdentifier(type);
        if (typeName == null) {
            throw new IllegalStateException("Missing identifier for " + fieldName);
        }
        JavaQName typeQName = this.getQName(typeName);
        return pSource.newJavaMethod(fieldName, typeQName, JavaSource.DEFAULT_PROTECTION);
    }

    private Parameter getParameter(AbstractJavaMethod pMethod, AST pAST) {
        AST paramNameAST = this.findChild(pAST, 68);
        if (paramNameAST == null) {
            throw new IllegalStateException("Missing IDENT AST");
        }
        String paramName = paramNameAST.getText();
        AST type = this.findChild(pAST, 13);
        if (type == null) {
            throw new IllegalStateException("Missing TYPE AST");
        }
        String typeName = this.parseIdentifier(type);
        JavaQName typeQName = this.getQName(typeName);
        return pMethod.addParam(typeQName, paramName);
    }

    private void parseParameter(AbstractJavaMethod pMethod, AST pAST) {
        Parameter param = this.getParameter(pMethod, pAST);
        this.parseModifiers(param, pAST);
    }

    private void parseParameters(AbstractJavaMethod pMethod, AST pAST) {
        AST params = this.findChild(pAST, 20);
        if (params == null) {
            throw new IllegalStateException("Missing PARAMETERS AST");
        }
        for (AST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 21: {
                    this.parseParameter(pMethod, child);
                }
            }
        }
    }

    private void parseExceptions(AbstractJavaMethod pMethod, AST pAST) {
        AST throwsClause = this.findChild(pAST, 109);
        if (throwsClause != null) {
            for (AST child = throwsClause.getFirstChild(); child != null; child = child.getNextSibling()) {
                String ident = this.parseSimpleIdentifier(child);
                JavaQName qName = this.getQName(ident);
                pMethod.addThrows(qName);
            }
        }
    }

    private void parseMethodDefinition(JavaSource pSource, AST pAST) {
        JavaMethod jm = this.getJavaMethod(pSource, pAST);
        this.parseModifiers(jm, pAST);
        this.parseParameters(jm, pAST);
        this.parseExceptions(jm, pAST);
    }

    private void parseConstructorDefinition(JavaSource pSource, AST pAST) {
        JavaConstructor jc = pSource.newJavaConstructor(JavaSource.DEFAULT_PROTECTION);
        this.parseModifiers(jc, pAST);
        this.parseParameters(jc, pAST);
        this.parseExceptions(jc, pAST);
    }

    private void parseObjects(JavaSource pSource, AST pAST) {
        AST objBlock = this.findChild(pAST, 6);
        if (objBlock == null) {
            throw new IllegalStateException("Missing OBKBLOCK");
        }
        block7: for (AST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 10: {
                    this.parseFieldDefinition(pSource, child);
                    continue block7;
                }
                case 9: {
                    this.parseMethodDefinition(pSource, child);
                    continue block7;
                }
                case 8: {
                    this.parseConstructorDefinition(pSource, child);
                    continue block7;
                }
                case 14: {
                    this.parseClassDefinition(pSource, JavaSource.CLASS, child);
                    continue block7;
                }
                case 15: {
                    this.parseClassDefinition(pSource, JavaSource.CLASS, child);
                }
            }
        }
    }

    private void parseClassDefinition(JavaSource pOuterClass, JavaSource.Type pType, AST pAST) {
        JavaSource currentClass = this.getJavaSource(pOuterClass, pAST);
        currentClass.setType(pType);
        this.parseModifiers(currentClass, pAST);
        this.parseImplementsOrExtends(currentClass, pAST, 18);
        if (!JavaSource.INTERFACE.equals(pType)) {
            this.parseImplementsOrExtends(currentClass, pAST, 19);
        }
        this.parseObjects(currentClass, pAST);
    }

    private void parseAST(AST pAST) {
        switch (pAST.getType()) {
            case 16: {
                this.parsePackageName(pAST);
                break;
            }
            case 30: {
                this.parseImportStatement(pAST);
                break;
            }
            case 14: {
                this.parseClassDefinition(null, JavaSource.CLASS, pAST);
                break;
            }
            case 15: {
                this.parseClassDefinition(null, JavaSource.INTERFACE, pAST);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            new JavaParser(new JavaSourceFactory()).parse(new File(args[i]));
        }
    }
}

