/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.ToolBarButtonUI;
import com.pagosoft.plaf.ToolBarToggleButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class PgsToolBarUI
extends MetalToolBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsToolBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("gradientStart", UIManager.get("ToolBar.gradientStart"));
        jComponent.putClientProperty("gradientEnd", UIManager.get("ToolBar.gradientEnd"));
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.setToolBarUI((JComponent)jComponent.getComponent(i));
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            if (PlafOptions.getStyle("ToolBar") == 0) {
                graphics.setColor(jComponent.getBackground());
                graphics.drawRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else {
                int n = ((JToolBar)jComponent).getOrientation();
                if (n == 0) {
                    PgsUtils.drawGradient(graphics, jComponent);
                } else {
                    PgsUtils.drawGradient(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), (Color)jComponent.getClientProperty("gradientStart"), (Color)jComponent.getClientProperty("gradientEnd"));
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    protected ContainerListener createContainerListener() {
        return new ToolBarContListener();
    }

    protected void setToolBarUI(JComponent jComponent) {
        if (jComponent instanceof JButton) {
            ((AbstractButton)jComponent).setUI((ToolBarButtonUI)ToolBarButtonUI.createUI(jComponent));
        } else if (jComponent instanceof JToggleButton) {
            ((AbstractButton)jComponent).setUI((ToolBarToggleButtonUI)ToolBarToggleButtonUI.createUI(jComponent));
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            PgsToolBarUI.this.setToolBarUI((JComponent)containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JComponent jComponent = (JComponent)containerEvent.getChild();
            if (jComponent instanceof JButton || jComponent instanceof JToggleButton) {
                ((AbstractButton)jComponent).setUI((ButtonUI)UIManager.getUI(jComponent));
            }
        }
    }
}

