/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.gui.menu.FileMenu;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.framework.swingextension.WelcomeButtonUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class WelcomePanel
extends JPanel {
    private JPanel footTextPanel;
    private JPanel rightTitlePanel;
    private JPanel leftTitlePanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private ResourceFactory resourceFactory;
    private ResourceBundle resourceBundle;
    private FileMenu fileMenu;

    public WelcomePanel(FileMenu fileMenu) {
        this.fileMenu = fileMenu;
        this.resourceBundle = ResourceBundle.getBundle("properties.WelcomeStrings", Locale.getDefault());
        this.resourceFactory = new ResourceFactory(this.resourceBundle);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setOpaque(false);
        JPanel shortcutPanel = new JPanel();
        shortcutPanel.setOpaque(false);
        shortcutPanel.setLayout(new GridLayout(2, 2));
        shortcutPanel.add(this.getLeftTitlePanel());
        shortcutPanel.add(this.getRightTitlePanel());
        shortcutPanel.add(this.getLeftPanel());
        shortcutPanel.add(this.getRightPanel());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)shortcutPanel, c);
        this.add((Component)panel, "North");
        this.add((Component)this.getFootTextPanel(), "South");
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Paint currentPaint = g2.getPaint();
        Theme cLAF = ThemeManager.getInstance().getTheme();
        GradientPaint paint = new GradientPaint(this.getWidth() / 2, -this.getHeight() / 4, cLAF.getWELCOME_BACKGROUND_START_COLOR(), this.getWidth() / 2, this.getHeight() + this.getHeight() / 4, cLAF.getWELCOME_BACKGROUND_END_COLOR());
        g2.setPaint(paint);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(currentPaint);
        super.paint(g);
    }

    private JPanel getLeftPanel() {
        if (this.leftPanel == null) {
            this.leftPanel = new JPanel();
            this.leftPanel.setOpaque(false);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.setBorder(new EmptyBorder(0, 0, 0, 45));
            JMenu newMenu = this.fileMenu.getFileNewMenu();
            for (int i = 0; i < newMenu.getItemCount(); ++i) {
                final JMenuItem item = newMenu.getItem(i);
                String label = item.getText();
                JButton newDiagramShortcut = new JButton(label.toLowerCase());
                newDiagramShortcut.setUI(new WelcomeButtonUI());
                newDiagramShortcut.setAlignmentX(1.0f);
                newDiagramShortcut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        item.doClick();
                    }
                });
                this.leftPanel.add(newDiagramShortcut);
            }
        }
        return this.leftPanel;
    }

    private JPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.rightPanel = new JPanel();
            this.rightPanel.setOpaque(false);
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightPanel.setBorder(new EmptyBorder(0, 45, 0, 45));
            JMenu recentMenu = this.fileMenu.getFileRecentMenu();
            for (int i = 0; i < recentMenu.getItemCount(); ++i) {
                final JMenuItem item = recentMenu.getItem(i);
                String label = item.getText();
                JButton fileShortcut = new JButton(label.toLowerCase());
                fileShortcut.setUI(new WelcomeButtonUI());
                fileShortcut.setAlignmentX(0.0f);
                fileShortcut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        item.doClick();
                    }
                });
                this.rightPanel.add(fileShortcut);
            }
        }
        return this.rightPanel;
    }

    private JPanel getLeftTitlePanel() {
        if (this.leftTitlePanel == null) {
            JLabel icon = new JLabel();
            ImageIcon imageIcon = this.resourceFactory.createIcon("welcomepanel.new_diagram.icon");
            icon.setIcon(imageIcon);
            JLabel title = new JLabel(this.fileMenu.getFileNewMenu().getText().toLowerCase());
            Theme cLAF = ThemeManager.getInstance().getTheme();
            title.setFont(cLAF.getWELCOME_BIG_FONT());
            title.setForeground(cLAF.getWELCOME_BIG_FOREGROUND_COLOR());
            title.setBorder(new EmptyBorder(0, 30, 0, 0));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(icon);
            panel.add(title);
            panel.setOpaque(false);
            this.leftTitlePanel = new JPanel();
            this.leftTitlePanel.setOpaque(false);
            this.leftTitlePanel.setLayout(new BorderLayout());
            this.leftTitlePanel.add((Component)panel, "East");
            this.leftTitlePanel.setBorder(new EmptyBorder(0, 0, 30, 45));
        }
        return this.leftTitlePanel;
    }

    private JPanel getRightTitlePanel() {
        if (this.rightTitlePanel == null) {
            JLabel icon = new JLabel();
            icon.setIcon(this.resourceFactory.createIcon("welcomepanel.recent_files.icon"));
            icon.setAlignmentX(0.0f);
            JLabel title = new JLabel(this.fileMenu.getFileRecentMenu().getText().toLowerCase());
            Theme cLAF = ThemeManager.getInstance().getTheme();
            title.setFont(cLAF.getWELCOME_BIG_FONT());
            title.setForeground(cLAF.getWELCOME_BIG_FOREGROUND_COLOR());
            title.setBorder(new EmptyBorder(0, 0, 0, 30));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(title);
            panel.add(icon);
            panel.setOpaque(false);
            this.rightTitlePanel = new JPanel();
            this.rightTitlePanel.setOpaque(false);
            this.rightTitlePanel.setLayout(new BorderLayout());
            this.rightTitlePanel.add((Component)panel, "West");
            this.rightTitlePanel.setBorder(new EmptyBorder(0, 45, 30, 0));
        }
        return this.rightTitlePanel;
    }

    private JPanel getFootTextPanel() {
        if (this.footTextPanel == null) {
            this.footTextPanel = new JPanel();
            this.footTextPanel.setOpaque(false);
            this.footTextPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
            this.footTextPanel.setLayout(new BoxLayout(this.footTextPanel, 1));
            this.footTextPanel.setAlignmentX(0.5f);
            JLabel text = new JLabel(this.resourceBundle.getString("welcomepanel.foot_text"));
            Theme cLAF = ThemeManager.getInstance().getTheme();
            text.setFont(cLAF.getWELCOME_SMALL_FONT());
            text.setForeground(cLAF.getWELCOME_BIG_FOREGROUND_COLOR());
            text.setAlignmentX(0.5f);
            this.footTextPanel.add(text);
        }
        return this.footTextPanel;
    }
}

