/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.gui.DialogFactoryListener;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DialogFactory {
    private static DialogFactory instance;
    private DialogFactoryListener listener;
    private int factoryMode = 2;
    private Frame dialogOwner;
    private ResourceBundle resourceBundle;
    private ResourceFactory resourceFactory;
    private static final Color JPANEL_BG_COLOR;
    private List<Object[]> delegatedDialogCache = new ArrayList<Object[]>();
    public static final int DELEGATED_MODE = 1;
    public static final int INTERNAL_MODE = 2;

    private DialogFactory() {
        this.resourceBundle = ResourceBundle.getBundle("properties.OtherStrings", Locale.getDefault());
        this.resourceFactory = new ResourceFactory(this.resourceBundle);
    }

    public static DialogFactory getInstance() {
        if (instance == null) {
            instance = new DialogFactory();
        }
        return instance;
    }

    public void setListener(DialogFactoryListener listener) {
        this.listener = listener;
        this.performCachedDialogs();
    }

    private void performCachedDialogs() {
        while (!this.delegatedDialogCache.isEmpty()) {
            Object[] object = this.delegatedDialogCache.get(0);
            JOptionPane optionPane = (JOptionPane)object[0];
            String title = (String)object[1];
            Boolean isModal = (Boolean)object[2];
            this.invokeListener(optionPane, title, isModal);
            this.delegatedDialogCache.remove(0);
        }
    }

    public void showErrorDialog(String message) {
        JOptionPane optionPane = new JOptionPane();
        ImageIcon icon = this.resourceFactory.createIcon("dialog.generic.error.icon");
        JLabel label = new JLabel(message);
        label.setFont(label.getFont().deriveFont(0));
        optionPane.setIcon(icon);
        optionPane.setMessage(label);
        String title = this.resourceBundle.getString("dialog.generic.error.title");
        this.showDialog(optionPane, title, true);
    }

    public void showWarningDialog(String message) {
        JOptionPane optionPane = new JOptionPane();
        ImageIcon icon = this.resourceFactory.createIcon("dialog.generic.warning.icon");
        JLabel label = new JLabel(message);
        label.setFont(label.getFont().deriveFont(0));
        optionPane.setIcon(icon);
        optionPane.setMessage(label);
        String title = this.resourceBundle.getString("dialog.generic.warning.title");
        this.showDialog(optionPane, title, true);
    }

    public void showInformationDialog(String message) {
        JOptionPane optionPane = new JOptionPane();
        ImageIcon icon = this.resourceFactory.createIcon("dialog.generic.information.icon");
        JLabel label = new JLabel(message);
        label.setFont(label.getFont().deriveFont(0));
        optionPane.setIcon(icon);
        optionPane.setMessage(label);
        String title = this.resourceBundle.getString("dialog.generic.information.title");
        this.showDialog(optionPane, title, true);
    }

    public void showDialog(JOptionPane optionPane, String title, boolean isModal) {
        this.updateBackgroundColor(optionPane);
        if (2 == this.factoryMode) {
            this.createDialog(optionPane, title, isModal);
        }
        if (1 == this.factoryMode) {
            this.invokeListener(optionPane, title, isModal);
        }
    }

    private void createDialog(JOptionPane optionPane, String title, boolean isModal) {
        if (this.dialogOwner == null) {
            throw new RuntimeException("Before invoking showDialog, you must call setDialogOwner() to defile the dialog owner");
        }
        final JDialog dialog = new JDialog(this.dialogOwner, title, isModal);
        dialog.setTitle(title);
        dialog.getContentPane().add(optionPane);
        dialog.pack();
        dialog.setResizable(false);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        });
        this.centerDialog(dialog, this.dialogOwner);
        dialog.setVisible(true);
    }

    private void updateBackgroundColor(Component component) {
        if (component.getBackground().equals(JPANEL_BG_COLOR)) {
            component.setBackground(ThemeManager.getInstance().getTheme().getBACKGROUND_COLOR());
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int ub = container.getComponentCount();
            for (int i = 0; i < ub; ++i) {
                this.updateBackgroundColor(container.getComponent(i));
            }
        }
    }

    private void centerDialog(JDialog dialog, Frame owner) {
        Rectangle b = owner.getBounds();
        double x = b.getX() + b.getWidth() / 2.0 - (double)(dialog.getWidth() / 2);
        double y = b.getY() + b.getHeight() / 2.0 - (double)(dialog.getHeight() / 2);
        Dimension screenSize = owner.getToolkit().getScreenSize();
        if (x + (double)dialog.getWidth() > screenSize.getWidth()) {
            x = screenSize.getWidth() - (double)dialog.getWidth();
        }
        if (y + (double)dialog.getHeight() > screenSize.getHeight()) {
            y = screenSize.getHeight() - (double)dialog.getHeight();
        }
        Point newLocation = new Point(Math.max((int)x, 0), Math.max((int)y, 0));
        dialog.setLocation(newLocation);
    }

    private void invokeListener(JOptionPane optionPane, String title, boolean isModal) {
        if (this.listener != null) {
            this.listener.mustDisplayPanel(optionPane, title, isModal);
        }
        if (this.listener == null) {
            this.delegatedDialogCache.add(new Object[]{optionPane, title, new Boolean(isModal)});
        }
    }

    public void setDialogOwner(Frame owner) {
        this.dialogOwner = owner;
    }

    public void setDialogMode(int dialogFactoryConstant) {
        switch (dialogFactoryConstant) {
            case 1: {
                this.factoryMode = 1;
                break;
            }
            case 2: {
                this.factoryMode = 2;
                break;
            }
            default: {
                throw new RuntimeException("Unknown dialog mode value");
            }
        }
    }

    static {
        JPANEL_BG_COLOR = new JPanel().getBackground();
    }
}

