/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.eclipseplugin.editors;

import com.horstmann.violet.eclipseplugin.editors.DiagramComposite;
import com.horstmann.violet.eclipseplugin.editors.DialogManager;
import com.horstmann.violet.eclipseplugin.editors.EclipseColorPicker;
import com.horstmann.violet.eclipseplugin.editors.FileDropTargetListener;
import com.horstmann.violet.eclipseplugin.tools.EclipseUtils;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.GraphService;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.DiagramPanelListener;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.ResourceTransfer;

public class VioletUMLEditor
extends EditorPart {
    public static final String ID = "com.horstmann.violet.eclipseplugin.editors.VioletUMLEditor";
    private DiagramPanel UMLDiagramPanel;
    private IFile UMLFile;

    public void doSave(IProgressMonitor monitor) {
        if (this.UMLFile != null) {
            try {
                Graph g = this.getUMLDiagramPanel().getGraphPanel().getGraph();
                ByteBuffer buffer = GraphService.serializeGraph(g);
                ByteArrayInputStream bis = new ByteArrayInputStream(buffer.array());
                this.UMLFile.setContents((InputStream)bis, true, true, monitor);
                this.firePropertyChange(257);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        DialogManager.createSingleton();
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fe = (IFileEditorInput)input;
            this.UMLFile = fe.getFile();
            this.setPartName(this.UMLFile.getName());
        }
    }

    public boolean isDirty() {
        return this.getUMLDiagramPanel().isSaveNeeded();
    }

    public void setFocus() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        ThemeManager.getInstance().switchToEclipseTheme(new EclipseColorPicker(this.getSite().getShell().getDisplay()));
        new DiagramComposite(parent, this.getUMLDiagramPanel());
        int operations = 7;
        Transfer[] types = new Transfer[]{ResourceTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)parent, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new FileDropTargetListener(this.getUMLDiagramPanel().getGraphPanel()));
    }

    public DiagramPanel getUMLDiagramPanel() {
        if (this.UMLDiagramPanel == null) {
            Graph aGraph = null;
            if (this.UMLFile != null) {
                try {
                    aGraph = GraphService.readGraph(this.UMLFile.getContents());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (this.UMLFile == null) {
                aGraph = new ClassDiagramGraph();
            }
            this.UMLDiagramPanel = new DiagramPanel(aGraph);
            this.UMLDiagramPanel.addListener(new DiagramPanelListener(){

                @Override
                public void mustOpenfile(URL url) {
                    IEditorSite site = VioletUMLEditor.this.getEditorSite();
                    Display d = site.getShell().getDisplay();
                    EclipseUtils.openUMLDiagram(url, d);
                }

                @Override
                public void graphCouldBeSaved() {
                    IEditorSite site = VioletUMLEditor.this.getEditorSite();
                    if (site != null) {
                        Display d = site.getShell().getDisplay();
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                VioletUMLEditor.this.firePropertyChange(257);
                            }
                        });
                    }
                }

                @Override
                public void titleChanged(String newTitle) {
                }
            });
        }
        return this.UMLDiagramPanel;
    }
}

